/*!
  \file
  \brief Luabind の初期化

  \author Satofumi KAMIMURA

  $Id: luabindInit.cpp 692 2009-03-29 16:17:43Z satofumi $
*/

#include "luabindInit.h"
#include "LuaHandler.h"
#include <luabind/luabind.hpp>

using namespace qrk;


namespace
{
  bool initialized_ = false;
};


lua_State* qrk::luabindInit(void)
{
  LuaHandler lua_handler;
  lua_State* lua = lua_handler.pointer();

  if (! initialized_) {
    luabind::open(lua_handler.pointer());
  }

  initialized_ = true;
  return lua;
}
