/*!
  \file
  \brief Lua への system モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindSystem.cpp 702 2009-04-01 19:37:33Z satofumi $
*/

#include "luabindSystem.h"
#include "luabindInit.h"
#include "delay.h"
#include "getTicks.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindSystem(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     def("delay", &delay),
     def("getTicks", &getTicks)
     ];
}
