/*!
  \file
  \brief はえ叩き

  \author Satofumi KAMIMURA

  $Id: FlyFlapp.cpp 712 2009-04-05 12:25:30Z satofumi $

  \todo ウィンドウのキャプションを設定する
*/

#include "Audio.h"
#include "Screen.h"
#include "LuaHandler.h"
#include "luabindSystem.h"
#include "luabindGeometry.h"
#include "luabindGui.h"
#include "luabindAudio.h"
#include "luabindFlyFlapp.h"
#include <cstring>

using namespace qrk;


namespace
{
  bool parseArgs(int argc, char *argv[])
  {
    // "--mute" が渡された場合、ミュートとみなす
    bool is_mute = false;
    for (int i = 1; i < argc; ++i) {
      if (! strcmp(argv[i], "--mute")) {
        is_mute = true;
        break;
      }
    }
    return is_mute;
  }


  void initializeLuabind(void)
  {
    luabindSystem();
    luabindGeometry();
    luabindGui();
    luabindAudio();
    luabindFlyFlapp();
  }
}


int main(int argc, char *argv[])
{
  // 画面の生成
  Screen screen;
  if (! screen.show(SDL_OPENGL)) {
    printf("Screen::show: %s\n", screen.what());
    exit(1);
  }

  // 音源の初期化
  bool is_mute = parseArgs(argc, argv);
  if (! is_mute) {
    Audio audio;
    audio.initialize();
  }

  // Lua の初期化と実行
  initializeLuabind();
  LuaHandler::doFile("strict.lua");
  return LuaHandler::doFile("FlyFlapp.lua");
}
