#ifndef INPUT_HANDLER_H
#define INPUT_HANDLER_H

/*!
  \file
  \brief 入力の受け付け

  \author Satofumi KAMIMURA

  $Id: InputHandler.h 707 2009-04-04 01:52:23Z satofumi $
*/

#include "Grid.h"
#include <memory>


class InputHandler
{
  InputHandler(const InputHandler& rhs);
  InputHandler& operator = (const InputHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  InputHandler(void);
  ~InputHandler(void);

  void update(void);
  bool isQuit(void);
  bool leftClicked(void);
  bool rightClicked(void);
  void setCursorPosition(const qrk::Grid<long>& position);
  qrk::Grid<long> cursorPosition(void);
};

#endif /* !INPUT_HANDLER_H */
