#ifndef SOUND_EFFECT_H
#define SOUND_EFFECT_H

/*!
  \file
  \brief 効果音の再生

  \author Satofumi KAMIMURA

  $Id: SoundEffect.h 712 2009-04-05 12:25:30Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief 効果音の再生
  */
  class SoundEffect
  {
    SoundEffect(void);
    SoundEffect(const SoundEffect& rhs);
    SoundEffect& operator = (const SoundEffect& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit SoundEffect(const char* play_file);
    ~SoundEffect(void);

    void play(float x = 0.0, float y = 0.0, float z = 0.1);
    void updatePosition(float x, float y, float z = 0.1);
    bool isPlaying(void);
  };
}

#endif /* !SOUND_EFFECT_H */
