#ifndef QRK_SURFACE_H
#define QRK_SURFACE_H

/*!
  \file
  \brief サーフェスのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Surface.h 707 2009-04-04 01:52:23Z satofumi $
*/

#include "Rect.h"


namespace qrk
{
  class Surface
  {
  public:
    virtual ~Surface(void)
    {
    }

    virtual bool isValid(void) const = 0;
    virtual Rect<long> rect(void) const = 0;
    virtual void setAlpha(float alpha) = 0;
    virtual float alpha(void) const = 0;

    virtual void draw(const Rect<long>* src, const Rect<long>* dest) = 0;

    // !!!
  };
}

#endif /* !QRK_SURFACE_H */
