/*!
  \file
  \brief Lua への AUDIO モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindAudio.cpp 702 2009-04-01 19:37:33Z satofumi $
*/

#include "luabindAudio.h"
#include "luabindInit.h"
#include "SoundEffect.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindAudio(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     class_<SoundEffect>("SoundEffect")
     .def(constructor<const char*>())
     .def("play", &SoundEffect::play)
     .def("updatePosition", &SoundEffect::updatePosition)
     .def("isPlaying", &SoundEffect::isPlaying)
     ];
}
