#ifndef COMMAND_PACKET_H
#define COMMAND_PACKET_H

/*!
  \file
  \brief コマンドの送受信

  \author Satofumi KAMIMURA

  $Id: CommandPacket.h 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "system_t.h"
#include <memory>


namespace qrk
{
  class Connection;


  class CommandPacket
  {
    CommandPacket(const CommandPacket& rhs);
    CommandPacket& operator = (const CommandPacket& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    CommandPacket(void);
    ~CommandPacket(void);

    void setConnection(Connection* connection);

    // !!! timeout の変更メソッド

    bool version(unsigned char* major,
                 unsigned char* minor, unsigned char* micro);
    bool position(long mm[], unsigned short* dir16);

    bool stop(void);

    bool setWheelVelocity(int id, long mm_per_sec);

    bool followLine(long x, long y, unsigned short dir16);

    bool spin(long dir16);
    bool rotate(long dir16);

    bool followCircle(long x, long y, long radius);

    // !!!
  };
}

#endif /* !COMMAND_PACKET_H */
