#ifndef QRK_FIND_COM_PORTS_H
#define QRK_FIND_COM_PORTS_H

/*!
  \file
  \brief COM ポート一覧の取得

  \author Satofumi KAMIMURA

  $Id: FindComPorts.h 1192 2009-07-30 09:10:18Z satofumi $

  \attention 動作確認は Windows XP のみ。他では未検証
*/

#include <string>
#include <vector>
#include <memory>


namespace qrk
{
  class IsUsbCom;


  /*!
    \brief シリアルポートの探索を行う

    Windows では、レジストリ情報を元に COM 一覧を取得して返す。\n
    Linux, MacOS では、与えられたパターンに一致するファイル名を取得して返す。
  */
  class FindComPorts
  {
    FindComPorts(const FindComPorts& rhs);
    FindComPorts& operator = (const FindComPorts& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    FindComPorts(IsUsbCom* is_usb = NULL);
    ~FindComPorts(void);

    void clear(void);
    void addBaseName(const char* base_name);
    std::vector<std::string> baseNames(void);

    /*!
      \brief COM ポート一覧の取得

      \retval COM 一覧が格納された string 配列
    */
    size_t find(std::vector<std::string>& ports);
  };
}

#endif /* !QRK_FIND_COM_PORTS_H */
