#ifndef SCIP_HANDLER_H
#define SCIP_HANDLER_H

/*!
  \file
  \brief SCIP プロトコル処理

  \author Satofumi KAMIMURA

  $Id: ScipHandler.h 1038 2009-06-18 09:57:01Z satofumi $
*/

#include <vector>
#include <memory>


namespace qrk
{
  class Connection;
  class RangeFinderParameter;


  //! SCIP プロトコル処理
  class ScipHandler
  {
    ScipHandler(const ScipHandler& rhs);
    ScipHandler& operator = (const ScipHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    ScipHandler(void);
    ~ScipHandler(void);

    static bool checkSum(char* buffer, int size, char actual_sum,
                         bool print_error = true);

    const char* what(void) const;

    void setConnection(Connection* connection);
    Connection* connection(void) const;
    bool connect(const char* device, long baudrate);

    bool loadParameter(RangeFinderParameter& parameter);

    int send(const char data[], int size);
    bool receiveData(std::vector<long>& data, long* timestamp);

    void laserOn(void);
    void laserOff(void);

    static long encode(const char* data, size_t size);
  };
}

#endif /* !SCIP_HANDLER_H */
