#ifndef QRK_SERIAL_DEVICE_H
#define QRK_SERIAL_DEVICE_H

/*!
  \file
  \brief シリアル通信

  \author Satofumi KAMIMURA

  $Id: SerialDevice.h 1000 2009-06-13 22:22:06Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  /*!
    \brief シリアル通信クラス
  */
  class SerialDevice : public Connection
  {
    SerialDevice(const SerialDevice& rhs);
    SerialDevice& operator = (const SerialDevice& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
    };
    SerialDevice(void);
    ~SerialDevice(void);

    const char* what(void);

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int receive(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !QRK_SERIAL_DEVICE_H */
