#ifndef QRK_STOP_WATCH_H
#define QRK_STOP_WATCH_H

/*!
  \file
  \brief 一時停止可能なタイマー

  \author Satofumi KAMIMURA

  $Id: StopWatch.h 1053 2009-06-20 22:52:51Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief 一時停止可能なタイマー
  */
  class StopWatch
  {
    StopWatch(const StopWatch& rhs);
    StopWatch& operator = (const StopWatch& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    StopWatch(void);
    ~StopWatch(void);


    /*!
      \brief 計測開始
    */
    void start(void);


    /*!
      \brief 計測終了

      ticks() の値をゼロに戻す
    */
    void stop(void);


    /*!
      \brief 計測の一時停止
    */
    void pause(void);


    /*!
      \brief 一時停止の再開
    */
    void resume(void);


    /*!
      \brief タイムスタンプの取得

      \retval タイムスタンプ [msec]
    */
    int ticks(void);


    /*!
      \brief 一時停止しているかどうか

      \retval true 停止中
      \retval false 動作中
    */
    bool isPause(void);


    void setSpeedRatio(double ratio);
  };
}

#endif /* !QRK_STOP_WATCH_H */
