#ifndef QRK_TCPIP_ACCEPTER_H
#define QRK_TCPIP_ACCEPTER_H

/*!
  \file
  \brief 接続の受付

  \author Satofumi KAMIMURA

  $Id: TcpipAccepter.h 1140 2009-07-13 21:41:41Z satofumi $
*/

#include <memory>


namespace qrk
{
  class TcpipSocket;


  /*!
    \brief 接続の受付
  */
  class TcpipAccepter
  {
    TcpipAccepter(const TcpipAccepter& rhs);
    TcpipAccepter& operator = (const TcpipAccepter& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      NoTimeout = -1,
    };
    TcpipAccepter(void);
    ~TcpipAccepter(void);

    const char* what(void) const;

    bool activate(long port);
    void deactivate(void);
    TcpipSocket* accept(int timeout = NoTimeout);

    /*!
      \brief サーバ名の取得

      \retval サーバ名

      \attention この関数を呼び出す前に activate() が成功していなければならない
      \see activate
    */
    const char* name(void);
  };
}

#endif /* !QRK_TCPIP_ACCEPTER_H */
