#ifndef QRK_TCPIP_SOCKET_H
#define QRK_TCPIP_SOCKET_H

/*!
  \file
  \brief TCP/IP 通信

  \author Satofumi KAMIMURA

  $Id: TcpipSocket.h 1140 2009-07-13 21:41:41Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  class SocketSet;


  /*!
    \brief TCP/IP 通信
  */
  class TcpipSocket : public Connection
  {
    TcpipSocket(const TcpipSocket& rhs);
    TcpipSocket& operator = (const TcpipSocket& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    TcpipSocket(void);
    TcpipSocket(void* socket);
    TcpipSocket(SocketSet* socket_set, void* socket = NULL);
    ~TcpipSocket(void);

    const char* what(void);

    bool connect(const char* host, long port);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int receive(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !QRK_TCPIP_SOCKET_H */
