/*!
  \file
  \brief UrgDevice に測定距離を保持させたクラス

  \author Satofumi KAMIMURA

  $Id: UrgDistance.cpp 1148 2009-07-17 00:21:48Z satofumi $
*/

#include "UrgDistance.h"

using namespace qrk;
using namespace std;


struct UrgDistance::pImpl
{
  UrgDevice urg_;
  vector<long> data_;
};



UrgDistance::UrgDistance(void) : pimpl(new pImpl)
{
}


UrgDistance::~UrgDistance(void)
{
}


const char* UrgDistance::what(void) const
{
  return pimpl->urg_.what();
}


bool UrgDistance::connect(const char* device, long baudrate)
{
  return pimpl->urg_.connect(device, baudrate);
}


void UrgDistance::disconnect(void)
{
  pimpl->urg_.disconnect();
}


bool UrgDistance::isConnected(void) const
{
  return pimpl->urg_.isConnected();
}


void UrgDistance::setConnection(Connection* connection)
{
  pimpl->urg_.setConnection(connection);
}


Connection* UrgDistance::connection(void)
{
  return pimpl->urg_.connection();
}


size_t UrgDistance::scanMsec(void) const
{
  return pimpl->urg_.scanMsec();
}


size_t UrgDistance::minDistance(void) const
{
  return pimpl->urg_.minDistance();
}


size_t UrgDistance::maxDistance(void) const
{
  return pimpl->urg_.maxDistance();
}


size_t UrgDistance::maxRange(void) const
{
  return pimpl->urg_.maxRange();
}


void UrgDistance::setTimestamp(long timestamp)
{
  pimpl->urg_.setTimestamp(timestamp);
}


void UrgDistance::setCaptureTimes(size_t times)
{
  pimpl->urg_.setCaptureTimes(times);
}


void UrgDistance::setCaptureRange(size_t begin_index, size_t end_index)
{
  pimpl->urg_.setCaptureRange(begin_index, end_index);
}


void UrgDistance::setRequestMode(UrgDevice::CaptureMode mode)
{
  pimpl->urg_.setRequestMode(mode);
}


void UrgDistance::requestData(void)
{
  pimpl->urg_.requestData();
}


bool UrgDistance::receiveData(std::vector<long>& data, long* timestamp)
{
  return pimpl->urg_.receiveData(data, timestamp);
}


bool UrgDistance::receiveData(void)
{
  long timestamp = 0;
  return receiveData(pimpl->data_, &timestamp);
}


long UrgDistance::at(size_t index) const
{
  return pimpl->data_.at(index);
}


size_t UrgDistance::rad2index(double radian) const
{
  return pimpl->urg_.rad2index(radian);
}


double UrgDistance::index2rad(size_t index) const
{
  return pimpl->urg_.index2rad(index);
}


void UrgDistance::laserOn(void)
{
  pimpl->urg_.laserOn();
}


void UrgDistance::laserOff(void)
{
  pimpl->urg_.laserOff();
}
