/*!
  \file
  \brief Lua への DifferentialDrive モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindDifferentialDrive.cpp 1235 2009-08-21 07:59:16Z satofumi $
*/

#include "luabindDifferentialDrive.h"
#include "mDifferentialDrive.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindDifferentialDrive(lua_State* L)
{
  module(L)
    [
     class_<mDifferentialDrive>("mDifferentialDrive")
     .def(constructor<>())
     .def("what", &mDifferentialDrive::what)
     .def("connect", &mDifferentialDrive::connect)
     .def("position", &mDifferentialDrive::position)
     .def("followLine", &mDifferentialDrive::followLine)
     .def("followCircle", &mDifferentialDrive::followCircle)
     .def("spin", &mDifferentialDrive::spin)
     .def("rotate", &mDifferentialDrive::rotate)
     .def("stop", &mDifferentialDrive::stop)
     ];
}
