/*!
  \file
  \brief Lua への Rangefinder モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindRangeFinder.cpp 1148 2009-07-17 00:21:48Z satofumi $
*/

#include "luabindRangeFinder.h"
#include "UrgDistance.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void luabindRangeFinder(lua_State* L)
{
  module(L)
    [
     class_<UrgDistance, Coordinate>("UrgDistance")
     .def(constructor<>())
     .def("what", &UrgDistance::what)
     .def("connect", &UrgDistance::connect)
     .def("disconnect", &UrgDistance::disconnect)
     .def("requestData", &UrgDistance::requestData)
     .def("receiveData", (bool(UrgDistance::*)(void)) &UrgDistance::receiveData)
     .def("at", &UrgDistance::at)
     ];
}
