/*!
  \file
  \brief Lua への system モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindSystem.cpp 1053 2009-06-20 22:52:51Z satofumi $
*/

#include "luabindSystem.h"
#include "delay.h"
#include "ticks.h"
#include "CycleTimer.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindSystem(lua_State* L)
{
  module(L)
    [
     def("delay", &delay),
     def("ticks", &ticks),

     class_<CycleTimer>("CycleTimer")
     .def(constructor<>())
     .def("waitMsec", &CycleTimer::waitMsec)
     .def("reset", &CycleTimer::reset)
     .def("setStrictCycle", &CycleTimer::setStrictCycle)
     .def("setCycleFps", &CycleTimer::setCycleFps)
     .def("cycleFps", &CycleTimer::cycleFps)
     .def("setCycleMsec", &CycleTimer::setCycleMsec)
     .def("cycleMsec", &CycleTimer::cycleMsec)
     .def("toNextCycleMsec", &CycleTimer::toNextCycleMsec)
     ];
}
