#ifndef QRK_BEEGO_MODEL_H
#define QRK_BEEGO_MODEL_H

/*!
  \file
  \brief ビーゴの ODE 用モデル

  \author Satofumi KAMIMURA

  $Id: BeegoModel.h 1162 2009-07-19 13:33:31Z satofumi $
*/

#include "Position.h"
#include <ode/ode.h>
#include <memory>


namespace qrk
{
  class OdeModel;


  class BeegoModel
  {
    BeegoModel(const BeegoModel& rhs);
    BeegoModel& operator = (const BeegoModel& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    BeegoModel(void);
    ~BeegoModel(void);

    void activate(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void) const;

    dBodyID objectId(void) const;

    // !!! 削除すること
    dBodyID wheelsId(int id) const;

    // !!! 削除すること
    dBodyID freeWheelBallId(void) const;

    // 車輪の半径
    // !!! id で左右輪に違うパラメータを指定できるようにする
    // !!!

    // モータと車輪のギヤ比の指定
    // !!!

    // エンコーダ分解能の指定
    // !!!

    // 車輪の速度を指定する
    void setMotorVelocity(int id, int count_per_msec);

    // エンコーダ値を読み出す
    long encoderCount(int id) const;
  };
}

#endif /* ! QRK_BEEGO_MODEL_H */
