#ifndef QRK_EXECUTION_TYPE_H
#define QRK_EXECUTION_TYPE_H

/*!
  \file
  \brief 実行のタイプ管理

  \author Satofumi KAMIMURA

  $Id: ExecutionType.h 1198 2009-08-01 23:41:55Z satofumi $
*/

#include <memory>


namespace qrk
{
  class ExecutionType
  {
    ExecutionType(void);
    ExecutionType(const ExecutionType& rhs);
    ExecutionType& operator = (const ExecutionType& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    typedef enum {
      RealDevice,               //!< 実機実行
      Recording,                //!< データを記録して実機実行
      Simulation,               //!< シミュレーション実行
      Playback,                 //!< 記録されたデータを用いて実行
    } Type;

    static ExecutionType* object(void);
    ~ExecutionType(void);

    void setType(Type type);
    Type type(void) const;
  };
}

#endif /* !QRK_EXECUTION_TYPE_H */
