/*!
  \file
  \brief マーカーの管理

  \author Satofumi KAMIMURA

  $Id: MarkerManager.cpp 1235 2009-08-21 07:59:16Z satofumi $

  \todo 実機のみで動作させているときは、何も処理をしないようにする
*/

#include "MarkerManager.h"
#include "OdeHandler.h"
#include "EventScheduler.h"
#include <map>
#include <string>

using namespace qrk;
using namespace std;


typedef pair<string, ModelManager::model_t*> ModelPair;
typedef multimap<string, ModelManager::model_t*>::iterator ModelsIterator;


struct MarkerManager::pImpl
{
  OdeHandler ode_;
  dWorldID world_;
  EventScheduler event_scheduler_;
  ModelManager model_manager_;
  multimap<string, ModelManager::model_t*> markers_;
  map<string, vector<dJointID> > marker_joints_;


  pImpl(void) : world_(ode_.world())
  {
  }


  static pImpl* object(void)
  {
    static pImpl singleton_object;
    return &singleton_object;
  }
};


MarkerManager::MarkerManager(void) : pimpl(pImpl::object())
{
}


MarkerManager::~MarkerManager(void)
{
}


void MarkerManager::clear(const char* name)
{
  pimpl->event_scheduler_.lock();

  // モデルの破棄
  pair<ModelsIterator, ModelsIterator> p = pimpl->markers_.equal_range(name);
  for (ModelsIterator it = p.first; it != p.second; ++it) {
    ModelManager::model_t* model = it->second;
    pimpl->model_manager_.remove(model);
    dBodyDestroy(model->body_id);
    delete model;
  }
  pimpl->markers_.erase(p.first, p.second);

  // ジョイントの破棄
  vector<dJointID>& joints = pimpl->marker_joints_[name];
  for (vector<dJointID>::iterator it = joints.begin();
       it != joints.end(); ++it) {
    dJointDestroy(*it);
  }
  pimpl->marker_joints_.erase(name);

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::draw(const char* name, ModelManager::model_t* model,
                         int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)model;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawModels(const char* name, ModelManager::model_t models[],
                               size_t n, int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)models;
  (void)n;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawPoints(const char* name,
                               std::vector<Point<long> >& points,
                               const Color& color, int radius,
                               long height)
{
  pimpl->event_scheduler_.lock();

  // multimap に model_t のデータを格納する
  for (vector<Point<long> >::iterator it = points.begin();
       it != points.end(); ++it) {
    ModelManager::model_t* model = new ModelManager::model_t;

    model->type = ModelManager::Sphere;
    model->body_id = dBodyCreate(pimpl->world_);
    dBodySetPosition(model->body_id,
                     it->x / 1000.0, it->y / 1000.0, height / 1000.0);

    dJointID joint_id = dJointCreateFixed(pimpl->world_, 0);
    dJointAttach(joint_id, model->body_id, 0);
    dJointSetFixed(joint_id);
    pimpl->marker_joints_[name].push_back(joint_id);

    model->color = color;
    model->obstacle = false;
    pimpl->model_manager_.addSphere(model, radius / 1000.0);

    pimpl->markers_.insert(ModelPair(name, model));
  }

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawLines(const char* name,
                              std::vector<Point<long> >& points,
                              const Color& color, int width,
                              int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)points;
  (void)color;
  (void)width;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawLinesStrip(const char* name,
                                   std::vector<Point<long> >& points,
                                   const Color& color, int width,
                                   int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)points;
  (void)color;
  (void)width;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawArrows(const char* name,
                               std::vector<Point<long> >& points,
                               const Color& color, int width,
                               int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)points;
  (void)color;
  (void)width;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}


void MarkerManager::drawArrowsStrip(const char* name,
                                    std::vector<Point<long> >& points,
                                    const Color& color, int width,
                                    int life_msec)
{
  pimpl->event_scheduler_.lock();

  (void)name;
  (void)points;
  (void)color;
  (void)width;
  (void)life_msec;

  // !!!

  pimpl->event_scheduler_.unlock();
}
