#ifndef QRK_ODE_MODEL_H
#define QRK_ODE_MODEL_H

/*!
  \file
  \brief ODE 用のモデル・インターフェース

  \author Satofumi KAMIMURA

  $Id: OdeModel.h 1151 2009-07-17 12:21:33Z satofumi $
*/

#include "Position.h"
#include <ode/ode.h>


namespace qrk
{
  class OdeModel
  {
  public:
    virtual ~OdeModel(void)
    {
    }


    // シミュレータ座標系での位置の設定
    virtual void setPosition(const Position<long>& position,
                             OdeModel* model, bool fixed) = 0;

    // シミュレータ座標系における位置の取得
    virtual Position<long> position(void) const = 0;


    // 描画用のオブジェクトを返す
    // !!! 色、種類、パラメータ、を返す


    // !!! いずれ削除する
    virtual dBodyID objectId(void) const = 0;
  };
}

#endif /* !QRK_ODE_MODEL_H */
