#ifndef QRK_SIMULATION_MAIN_H
#define QRK_SIMULATION_MAIN_H

/*!
  \file
  \brief シミュレーション時のメイン関数実行用

  \author Satofumi KAMIMURA

  $Id: SimulationMain.h 1138 2009-07-13 10:40:08Z satofumi $
*/

#include "EventScheduler.h"
#include <QThread>


namespace qrk
{
  typedef int MainFunction(int argc, char *argv[]);


  class SimulationMain : public QThread
  {
    Q_OBJECT;

    friend class SimulationWindow;

    SimulationMain(const SimulationMain& rhs);
    SimulationMain& operator = (const SimulationMain& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

    EventScheduler event_scheduler_;

  public:
    SimulationMain(MainFunction* function, int argc, char *argv[]);
    ~SimulationMain(void);
    void run(void);
  };
}

#endif /* !QRK_SIMULATION_MAIN_H */
