#ifndef QRK_SIMULATION_WINDOW_H
#define QRK_SIMULATION_WINDOW_H

/*!
  \file
  \brief シミュレータ用のウィンドウ

  \author Satofumi KAMIMURA

  $Id: SimulationWindow.h 1238 2009-08-22 07:05:53Z satofumi $
*/

#include "ui_SimulationWindowForm.h"
#include <memory>


namespace qrk
{
  typedef int MainFunction(int argc, char *argv[]);


  class ArgsInformation
  {
  public:
    typedef enum {
      Normal,
      Recording,
      Playback,
    } Mode;

    bool simulation_;
    Mode mode_;


    ArgsInformation(void) : simulation_(false), mode_(Normal)
    {
    }
  };


  class SimulationWindow : public QMainWindow, private Ui::SimulationWindowForm
  {
    Q_OBJECT;

    SimulationWindow(const SimulationWindow& rhs);
    SimulationWindow& operator = (const SimulationWindow& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  private slots:
    void quitHandler(void);
    void closeEvent(QCloseEvent* event);
    void playPressed(void);
    void pausePressed(void);
    void moreFasterPressed(void);
    void moreSlowerPressed(void);
    void redraw(void);
    void aboutApplication(void);
    void ticksControlClosed(void);
    void ticksControlChecked(bool checked);

  public:
    SimulationWindow(MainFunction* program, int argc, char *argv[]);
    ~SimulationWindow(void);

    static void parseArgs(ArgsInformation& args, int argc, char *argv[]);
  };
}

#endif /* !QRK_SIMULATION_WINDOW_H */
