#ifndef QRK_URG_DEVICE_DEVICE_H
#define QRK_URG_DEVICE_DEVICE_H

/*!
  \file
  \brief UrgDevice のシミュレータ

  \author Satofumi KAMIMURA

  $Id: UrgDevice_device.h 1142 2009-07-14 13:13:25Z satofumi $
*/

#include "Device.h"
#include "OdeModel.h"


namespace qrk
{
  class UrgDevice_device : public Device, public OdeModel
  {
    UrgDevice_device(const UrgDevice_device& rhs);
    UrgDevice_device& operator = (const UrgDevice_device& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    UrgDevice_device(const char* device);
    ~UrgDevice_device(void);

    void setParameter(const char* type, const char* parameter);
    void activate(void);

    void execute(void);
    size_t nextExecuteInterval(void) const;

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = true);
    Position<long> position(void) const;

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_URG_DEVICE_DEVICE_H */
