/*!
  \file
  \brief 待機

  \author Satofumi KAMIMURA

  $Id: delay.cpp 1175 2009-07-22 22:26:13Z satofumi $
*/

#include "delay.h"
#include "system_delay.h"
#include "ExecutionType.h"
#include "EventScheduler.h"
#include "Lock.h"

using namespace qrk;


void qrk::delay(int msec)
{
  static EventScheduler event_scheduler_;
  static ExecutionType::Type type = ExecutionType::object()->type();

  if (type == ExecutionType::Simulation) {
    ConditionVariable condition;
    if (event_scheduler_.registerDelayEvent(&condition, msec)) {
      Lock mutex;
      mutex.lock();
      // !!! ここでの待機中にスレッドが終了すると
      // !!! "QWaitCondition: mutex destroy failure." が発生する
      // !!! 対処方法は不明。保留中
      condition.wait(&mutex);
    } else {
      // この分岐に入るのは、EventScheduler のスレッドが停止しているとき
      fprintf(stderr, "delay: thread stopped.\n");
      system_delay(1000);
    }

  } else {
    system_delay(msec);
  }
}
