/*!
  \file
  \brief Lua への Simulator 登録

  \author Satofumi KAMIMURA

  $Id: luabindSimulator.cpp 1235 2009-08-21 07:59:16Z satofumi $
*/

#include "luabindSimulator.h"
#include "DifferentialDrive_device.h"
#include "UrgDevice_device.h"
#include "DeviceManager.h"
#include "CameraViewManager.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindSimulator(lua_State* L)
{
  module(L)
    [
     class_<Device>("Device")
     .def("activate", &Device::activate),

     class_<OdeModel>("OdeModel")
     .def("setPosition", &OdeModel::setPosition)
     .def("position", &OdeModel::position),

     class_<DifferentialDrive_device, Device, OdeModel>
     ("DifferentialDrive_device")
     .def("activate", &DifferentialDrive_device::activate)
     .def("setPosition", &DifferentialDrive_device::setPosition),

     class_<UrgDevice_device, Device, OdeModel>("UrgDevice_device")
     .def("activate", &UrgDevice_device::activate)
     .def("setPosition", &UrgDevice_device::setPosition),

     class_<DeviceManager>("DeviceManager")
     .def(constructor<>())
     .def("createDevice", &DeviceManager::createDevice)
     .def("createEvent", &DeviceManager::createEvent)
     .def("device", &DeviceManager::device)
     .def("model", &DeviceManager::model),

     class_<CameraViewManager>("CameraViewManager")
     .def(constructor<>())
     .def("setInitialView", &CameraViewManager::setInitialView)
     .def("setBaseView", &CameraViewManager::setBaseView)
     .def("setView", &CameraViewManager::setView)
     .def("setScale", &CameraViewManager::setScale)
     ];
}
