/*!
  \file
  \brief モニタ対応の UrgDevice クラス

  \author Satofumi KAMIMURA

  $Id: mUrgDevice.cpp 1211 2009-08-06 13:50:45Z satofumi $
*/

#include "mUrgDevice.h"
#include "ExecutionType.h"
#include "DeviceManager.h"
#include "TcpipSocket.h"

using namespace qrk;


struct mUrgDevice::pImpl
{
  UrgDevice urg_;
  ExecutionType::Type type_;
  Connection* created_connection_;


  pImpl(void)
    : type_(ExecutionType::object()->type()), created_connection_(NULL)
  {
    if (type_ == ExecutionType::Simulation) {
      created_connection_ = new TcpipSocket;
      urg_.setConnection(created_connection_);
    }
  }


  ~pImpl(void)
  {
    delete created_connection_;
  }
};


mUrgDevice::mUrgDevice(void) : pimpl(new pImpl)
{
}


mUrgDevice::~mUrgDevice(void)
{
}


const char* mUrgDevice::what(void) const
{
  return pimpl->urg_.what();
}


bool mUrgDevice::connect(const char* device, long baudrate)
{
  DeviceManager device_manager;
  long port;

  switch (pimpl->type_) {
  case ExecutionType::Simulation:
    // ポート番号を取得し、TCP/IP として接続する
    port = device_manager.port(device);
    return pimpl->urg_.connect("localhost", port);
    break;

  case ExecutionType::RealDevice:
  case ExecutionType::Recording:
    // 指定されたデバイスにシリアルとして接続する
    return pimpl->urg_.connect(device, baudrate);
    break;

  case ExecutionType::Playback:
    // !!! 接続しない
    // !!! 記録しておいた結果を読み出して返す
    // !!!
    return false;
    break;
  }

  return false;
}


void mUrgDevice::disconnect(void)
{
  pimpl->urg_.disconnect();
}


bool mUrgDevice::isConnected(void) const
{
  return pimpl->urg_.isConnected();
}


void mUrgDevice::setConnection(Connection* connection)
{
  pimpl->urg_.setConnection(connection);
}


Connection* mUrgDevice::connection(void)
{
  return pimpl->urg_.connection();
}


size_t mUrgDevice::scanMsec(void) const
{
  return pimpl->urg_.scanMsec();
}


size_t mUrgDevice::minDistance(void) const
{
  return pimpl->urg_.minDistance();
}


size_t mUrgDevice::maxDistance(void) const
{
  return pimpl->urg_.maxDistance();
}


size_t mUrgDevice::maxRange(void) const
{
  return pimpl->urg_.maxRange();
}


void mUrgDevice::setTimestamp(long timestamp)
{
  pimpl->urg_.setTimestamp(timestamp);
}


void mUrgDevice::setCaptureTimes(size_t times)
{
  pimpl->urg_.setCaptureTimes(times);
}


void mUrgDevice::setCaptureRange(size_t begin_index, size_t end_index)
{
  pimpl->urg_.setCaptureRange(begin_index, end_index);
}


void mUrgDevice::setRequestMode(UrgDevice::CaptureMode mode)
{
  pimpl->urg_.setRequestMode(mode);
}


void mUrgDevice::requestData(void)
{
  pimpl->urg_.requestData();
}


bool mUrgDevice::receiveData(std::vector<long>& data, long* timestamp)
{
  return pimpl->urg_.receiveData(data, timestamp);
}


size_t mUrgDevice::rad2index(double radian) const
{
  return pimpl->urg_.rad2index(radian);
}


double mUrgDevice::index2rad(size_t index) const
{
  return pimpl->urg_.index2rad(index);
}


void mUrgDevice::laserOn(void)
{
  pimpl->urg_.laserOn();
}


void mUrgDevice::laserOff(void)
{
  pimpl->urg_.laserOff();
}
