#ifndef QRK_M_URG_DEVICE_H
#define QRK_M_URG_DEVICE_H

/*!
  \file
  \brief モニタ対応の UrgDevice クラス

  \author Satofumi KAMIMURA

  $Id: mUrgDevice.h 1230 2009-08-19 02:15:55Z satofumi $
*/

#include "UrgDevice.h"


namespace qrk
{
  //! モニタ対応の UrgDevice クラス
  class mUrgDevice : public Coordinate, public RangeFinder
  {
    mUrgDevice(const mUrgDevice& rhs);
    mUrgDevice& operator = (const mUrgDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    mUrgDevice(void);
    ~mUrgDevice(void);

    const char* what(void) const;
    bool connect(const char* device,
                 long baudrate = UrgDevice::DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);
    size_t scanMsec(void) const;
    size_t minDistance(void) const;
    size_t maxDistance(void) const;
    size_t maxRange(void) const;
    void setTimestamp(long timestamp);
    void setCaptureTimes(size_t times);
    void setCaptureRange(size_t begin_index, size_t end_index);
    void setRequestMode(UrgDevice::CaptureMode mode);
    void requestData(void);
    bool receiveData(std::vector<long>& data, long* timestamp = NULL);
    size_t rad2index(double radian) const;
    double index2rad(size_t index) const;
    void laserOn(void);
    void laserOff(void);
  };
}

#endif /* !QRK_M_URG_DEVICE_H */
