/*!
  \file
  \brief motor_ctrol.c のシミュレーション用の実装

  \author Satofumi KAMIMURA

  $Id: motor_control.cpp 1209 2009-08-05 13:11:59Z satofumi $
*/

#include "motor_control.h"
#include "encoder_handler.h"
#include "BeegoModel.h"

using namespace qrk;


namespace
{
  BeegoModel* model_ = NULL;
}


void motor_setModel(BeegoModel* model)
{
  model_ = model;
}


void motor_initialize(int id, motor_t *motor)
{
  motor->id = id;
}


void motor_reset(motor_t *motor)
{
  static_cast<void>(motor);

  // 実装しない
}


void motor_setMode(int id, MotorMode mode)
{
  static_cast<void>(id);
  static_cast<void>(mode);

  // 実装しない
}


void motor_setVelocity(int id, int count_per_msec,
                       int encoder_count, motor_t *motor)
{
  static_cast<void>(encoder_count);
  static_cast<void>(motor);

  // encoder_count と motor に関係なく、指定速度でモータを回転させる
  model_->setMotorVelocity(id, count_per_msec);
}
