#ifndef QRK_QRK_MAIN_H
#define QRK_QRK_MAIN_H

/*!
  \file
  \brief シミュレーション時の main 置換用

  \author Satofumi KAMIMURA

  $Id: qrk_main.h 1187 2009-07-26 02:49:51Z satofumi $
*/

#include "SimulationWindow.h"
#include <QApplication>


int program_main(int argc, char *argv[]);


int main(int argc, char *argv[])
{
  qrk::ArgsInformation args;
  qrk::SimulationWindow::parseArgs(args, argc, argv);
  if ((args.mode_ != qrk::ArgsInformation::Playback) &&
      (! args.simulation_)) {
    // 実機実行時
    return program_main(argc, argv);
  }

  // シミュレーション時、プレイバック時
  QApplication app(argc, argv);

  qrk::SimulationWindow simulator(program_main, argc, argv);
  simulator.show();

  return app.exec();
}


#define main program_main

#endif /* !QRK_QRK_MAIN_H */
