#ifndef QRK_BODY_T_H
#define QRK_BODY_T_H

/*!
  \file
  \brief 筐体

  \author Satofumi KAMIMURA

  $Id: body_t.h 1216 2009-08-09 08:35:00Z satofumi $
*/

#include "math_utils.h"

//#define BODY_T_TREAD_MM 285.0
#define BODY_T_TREAD_MM 325.0


enum {
  BODY_T_TREAD_R_SHIFT = 3,

  // トレッド幅[mm] (最大 4096 [mm])
  BODY_T_TREAD = (long)(BODY_T_TREAD_MM * (1 << BODY_T_TREAD_R_SHIFT)),

  // 2.0 * M_PI * トレッド * 固定小数点のシフト分
  BODY_T_ROTATE_COEFFECIENT =
  (long)(2.0 * M_PI * BODY_T_TREAD_MM * (1 << BODY_T_TREAD_R_SHIFT)),
};


//! 筐体
typedef struct
{
  char reset;
  long rotate_coeffecient;
} body_t;

#endif /* !QRK_BODY_T_H */
