#ifndef FOLLOW_CONTROL_H
#define FOLLOW_CONTROL_H

/*!
  \file
  \brief 経路追従

  \author Satofumi KAMIMURA

  $Id: follow_control.h 1218 2009-08-11 00:42:36Z satofumi $
*/

#include "follow_t.h"
#include "position_t.h"
#include "path_t.h"


extern void follow_initialize(follow_t *follow, long acceleration);
extern void follow_reset(follow_t *follow);
extern long follow_velocityControl(follow_t *follow);
extern long follow_positionControl(follow_t *follow, long difference);

// 直線追従
extern long follow_line(follow_t *rotate, const position_t *position,
                        const path_t *path);

// 円弧追従
extern long follow_circle(follow_t *rotate, const position_t *position,
                          const path_t *path);

// 回転制御
extern void spin(void);

#endif /* !FOLLOW_CONTROL_H */
