#ifndef QRK_FOLLOW_T_H
#define QRK_FOLLOW_T_H

/*!
  \file
  \brief 追従制御

  \author Satofumi KAMIMURA

  $Id: follow_t.h 1230 2009-08-19 02:15:55Z satofumi $
*/

enum {
  // !!! なぜか、10 より 8 の方が経路追従において発振しない
  // !!! その理由を理解する
  FOLLOW_SHIFT = 8,
};

#ifndef FOLLOW_T_DEFAULT_STRAIGHT_ACCELERATION
#define FOLLOW_T_DEFAULT_STRAIGHT_ACCELERATION (300 << FOLLOW_SHIFT) //!< [mm/sec^2]
#endif

// !!! この加速度は、シミュレータ上の動作に反映されていないように思える
// !!! 実際の挙動を確認して修正する
#ifndef FOLLOW_T_DEFAULT_ROTATE_ACCELERATION
#define FOLLOW_T_DEFAULT_ROTATE_ACCELERATION (65536 << FOLLOW_SHIFT) //!< [dir16]
#endif


//! 追従制御
typedef struct
{
  char reset;
  long target_velocity;         //!< 目標速度
  long control_velocity;        //!< 制御中の速度
  long control_acceleration;    //!< 加速度
} follow_t;

#endif /* !QRK_FOLLOW_T_H */
