#ifndef I_SIN_COS_H
#define I_SIN_COS_H

/*!
  \file
  \brief 整数型の sin(), cos()

  整数型の三角関数(sin(), cos())を提供
  角度の細かさ、最大値はコンパイル時に指定

  \author Satofumi KAMIMURA

  $Id: create_isincos.rb 1203 2009-08-03 01:53:16Z satofumi $
*/


enum {
  ISINCOS_ANGLE_DIVIDED = 65536, /* [0, 65536] */
  ISINCOS_VALUE_MAX = 32768,	/* [-32768, +32768] */
  ISINCOS_VALUE_SHIFT = 15,
};


extern int isin(unsigned short dir16);
extern int icos(unsigned short dir16);

#endif /* !I_SIN_COS_H */

