#ifndef PWM_CONTROL_H
#define PWM_CONTROL_H

/*!
  \file
  \brief PWM 制御

  \author Satofumi KAMIMURA

  $Id: pwm_control.h 1015 2009-06-15 22:31:42Z satofumi $
*/


/*!
  \brief モータ制御用の PWM を初期化

  \param[in] id デバイス ID
*/
extern void pwm_initialize(int id);


/*!
  \brief モータ制御用の IO 出力を設定

  \param[in] id デバイス ID
  \param[in] output 出力の下位 2 bit を出力に対応させる
*/
extern void pwm_setIo(int id, unsigned char output);


/*!
  \brief モータ制御用の PWM を出力

  \param[in] id デバイス ID
  \param[in] 0 のときに常時 L 出力、255 のときに常時 H 出力となる
*/
extern void pwm_setDuty(int id, unsigned char duty);

#endif /* !PWM_CONTROL_H */
