#ifndef ROBOT_T_H
#define ROBOT_T_H

/*!
  \file
  \brief ロボット用の構造体

  \author Satofumi KAMIMURA

  $Id: robot_t.h 1211 2009-08-06 13:50:45Z satofumi $
*/

#include "system_t.h"
#include "motor_t.h"
#include "position_t.h"
#include "path_t.h"
#include "direct_t.h"


//! ロボット制御
typedef struct
{
  char reset;
  system_t system;

  encoder_t encoder[2];
  motor_t motor[2];
  wheel_t wheel[2];

  body_t body;
  position_t position;
  position_t follow_position;

  path_t path;
  follow_t straight;
  follow_t rotate;

  direct_t direct;

} robot_t;

#endif /* !ROBOT_T_H */
