#ifndef QRK_SYSTEM_T_H
#define QRK_SYSTEM_T_H

/*!
  \file
  \brief システム情報

  \author Satofumi KAMIMURA

  $Id: system_t.h 1209 2009-08-05 13:11:59Z satofumi $
*/


//! コントローラの制御モード
typedef enum {
  NormalControl,                // 通常の制御
  DirectControl_wheel,          // 車輪を直接制御
  DirectControl_motor,          // モータを直接制御
} ControlMode;


//! \brief システム情報
typedef struct
{
  char reset;

  // バージョン情報
  unsigned char major;
  unsigned char minor;
  unsigned char micro;

  // 制御開始からの時間
  unsigned long sec;
  unsigned short msec;

  // 制御モード
  ControlMode mode;

} system_t;

#endif /* !QRK_SYSTEM_T_H */
