#ifndef QRK_WHEEL_T_H
#define QRK_WHEEL_T_H

/*!
  \file
  \brief 車輪制御

  \author Satofumi KAMIMURA

  $Id: wheel_t.h 1217 2009-08-10 22:38:36Z satofumi $
*/

#include <math.h>


// 車輪の有効半径
#ifndef WHEEL_T_RADIUS
#define WHEEL_T_RADIUS (85.0 / 2.0)
#endif

// ギヤ比 (モータが GEAR_RATIO だけ回転したときに、車輪が１回転する値)
#ifndef WHEEL_T_GEAR_RATIO
#define WHEEL_T_GEAR_RATIO (3249.0 / 169.0 * 45.0 / 16.0)
#endif

// 車輪の最大速
#define WHEEL_MAX_MM (600)


enum {
  // 小数点の位置は、10 bit 目
  WheelCoefficient =
  (long)(32.768 * WHEEL_T_GEAR_RATIO / (2.0 * M_PI * WHEEL_T_RADIUS) * 1024.0),
};


//! 車輪制御
typedef struct
{
  char reset;

  long coefficient;             //!< 計算用の定数

  // !!! 微小な速度指定を実現するための変数
} wheel_t;

#endif /* !QRK_WHEEL_T_H */
