#ifndef THEME_CLOCK_WIDGET_H
#define THEME_CLOCK_WIDGET_H

/*!
  \file
  \brief テーマ時計の描画

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <QWidget>

class ThemeProperty;


class ThemeClockWidget : public QWidget {
  Q_OBJECT;

  ThemeClockWidget(const ThemeClockWidget& rhs);
  ThemeClockWidget& operator = (const ThemeClockWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  void firstUpdate(void);

 private slots:
  void startTimer(void);
  void updateClock(void);

 protected:
  void resizeEvent(QResizeEvent* event);
  void mousePressEvent(QMouseEvent* event);
  void mouseMoveEvent(QMouseEvent* event);
  void dragEnterEvent(QDragEnterEvent* event);
  void dragMoveEvent(QDragEnterEvent* event);
  void dropEvent(QDropEvent* event);

 public:
  ThemeClockWidget(ThemeProperty* theme, QWidget* parent = NULL);
  ~ThemeClockWidget(void);
};

#endif /* !THEME_CLOCK_WIDGET_H */
