#ifndef THEME_PROPERTY_H
#define THEME_PROPERTY_H

/*!
  \file
  \brief テーマデータの読み出し

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class QString;
class QPixmap;


class ThemeProperty {
  ThemeProperty(const ThemeProperty& rhs);
  ThemeProperty& operator = (const ThemeProperty& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 public:
  ThemeProperty(const QString& theme_name);
  ~ThemeProperty(void);

  bool getPixmap(QPixmap& image, const char* tag) const;
  int getPosition(const char* tag) const;
  void close(void);
};

#endif /* !THEME_PROPERTY_H */
