/*!
  \file
  \brief Qt ɂ lm_tmclock ̎

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QApplication>
#include "QtmSettings.h"
#include "ThemeProperty.h"
#include "ThemeClockWidget.h"


static void printHelp(void) {
  printf("help!\n");

  // !!! ̃Av̐
  // !!! IvV̐
  // !!! A
}


static void optionHandler(QtmSettings& settings, int argc, char *argv[]) {
  for (int i = 1; i < argc; ++i) {
    if ((! strcmp(argv[i], "-t")) || (! strcmp(argv[i], "--theme"))) {

      // R}hCw̃e[}o
      if (i < (argc - 1)) {
        settings.theme_name = argv[i + 1];
      }
    } else if ((! strcmp(argv[i], "--geometry")) ||
               (! strcmp(argv[i], "-geometry"))) {

      // ʒuw肪΁Aݒ̈ʒuw𖳌ɂ
      // !!!

    } else if ((! strcmp(argv[i], "-h")) || (! strcmp(argv[i], "--help"))) {

      // wvo͂ďI
      printHelp();
      exit(1);

    } else {
      // ŵȂڂ̏ꍇAe[}ƂĈ
      if (settings.theme_name.isEmpty()) {
        settings.theme_name = argv[i];
      }
    }
  }
}


int main(int argc, char *argv[]) {
  // dNh
  // !!!

  QApplication app(argc, argv);

  // ݒ̓ǂ݂
  QtmSettings settings;
  settings.load();

  // w̔f
  optionHandler(settings, argc, argv);

  // w肳ꂽe[}̓ǂ݂
  ThemeProperty theme(settings.theme_name);

  // v̕`ƕ\
  ThemeClockWidget clock(&theme);
  clock.show();
  theme.close();

  return app.exec();
}
