/*!
  \file
  \brief データファイルのリリース処理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <string>
#include "ReleaseDataFile.h"
#include "ArchiveConfig.h"
#include "RrdaDecoder.h"


bool releaseDataFile(ArchiveConfig& archive_config) {

  RrdaDecoder decoder(archive_config.getReleaseName(),
                      archive_config.getRrdaKey());

  const char* tags[] = {
    "config", "base", "digital", "hari_h", "hari_m", "hari_s",
  };

  size_t n = sizeof(tags) / sizeof(tags[0]);

  // 通常データ
  for (size_t i = 0; i < n; ++i) {
    const char* value = archive_config.getNormalData(tags[i]);
    if (strlen(value) > 0) {
      decoder.setNormalData(tags[i], value);
    }
  }

  // 暗号化データ
  for (size_t i = 0; i < n; ++i) {
    const char* value = archive_config.getRestrictData(tags[i]);
    if (strlen(value) > 0) {
      decoder.setRestrictData(tags[i], value);
    }
  }

  return decoder.release();
}

