#ifndef RELEASE_DIALOG_H
#define RELEASE_DIALOG_H

/*!
  \file
  \brief リリース用ダイアログ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_ReleaseDialogForm.h"


class ReleaseDialog : public QDialog, private Ui::ReleaseDialog {
  Q_OBJECT;

  ReleaseDialog(const ReleaseDialog& rhs);
  ReleaseDialog& operator = (const ReleaseDialog& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void acceptedHandler(void);

public:
  ReleaseDialog(QDialog* parent = 0);
  ~ReleaseDialog(void);


  /*!
    \brief 初期値の設定

    \param release_file [i] リリース出力のファイル名
    \param rrda_key [i] RRDA キー
  */
  void setDefaultValue(const std::string& release_file,
                       const std::string& rrda_key);

signals:

  /*!
    \brief リリース [signal]

    \param file [o] リリースファイル名
    \param key [o] RRDA キー
  */
  void release(const QString& file, const QString& key);
};

#endif /* !RELEASE_DIALOG_H */
