/*!
  \brief string p split ֐

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SplitString.h"


// ؂蕶A󔒂ɒuĕs
size_t qrk::split(std::vector<std::string>& tokens,
                  const std::string& line, const char* split_pattern) {

  size_t next_first = 0;
  while (true) {

    // p^[łȂʒuT
    size_t first_position = line.find_first_not_of(split_pattern, next_first);
    if (first_position == std::string::npos) {
      // ȍ~Ƀg[NȂ߁Af
      break;
    }

    // o^[̏IT
    size_t last_position = line.find_first_of(split_pattern, first_position);
    size_t length = std::string::npos;
    if (last_position != std::string::npos) {
      length = last_position - first_position;
    }
    tokens.push_back(line.substr(first_position, length));

    if (next_first == std::string::npos) {
      // Ō܂ŒT߁Af
      break;
    }

    next_first = last_position;
  }
  return tokens.size();
}
