/*!
  \file
  \brief SJIS ւ̕ϊ

  Windows XP ɂāAt@C̃pX SJIS ɂ邽߂ɗp

  \author Satofumi KAMIMURA

  $Id$

  \todo Windows 2000 ł삷悤ɂ
*/

#include <QString>
#ifdef Q_WS_WIN
#include <QLocale>
#include <QTextCodec>
#include <QSysInfo>
#endif
#include "ToSjisString.h"


const QString qrk::toSjisString(const QString& text) {

#ifdef Q_WS_WIN

  if (QLocale::system().name().compare("ja_JP")) {
    // {ꃍP[łȂ
    return text;
  }

  QSysInfo::WinVersion version = QSysInfo::windowsVersion();

  if (version == QSysInfo::WV_XP) {
    // {ꃍP[̏ꍇASJIS ɕϊ
    QTextCodec* codec = QTextCodec::codecForName("Shift-JIS");
    return codec->fromUnicode(text);

  } else {
    return text;
  }
#else
  return text;
#endif
}
