/*!
  \file
  \brief SJIS 文字列への変換

  Windows XP 環境において、ファイルのパスを SJIS にするために用いる

  \author Satofumi KAMIMURA

  $Id$

  \todo Windows 2000 環境でも動作するようにする
*/

#include <QString>
#ifdef Q_WS_WIN
#include <QLocale>
#include <QTextCodec>
#include <QSysInfo>
#endif
#include "ToSjisString.h"


const QString qrk::toSjisString(const QString& text) {

#ifdef Q_WS_WIN

  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでない
    return text;
  }

  QSysInfo::WinVersion version = QSysInfo::windowsVersion();

  if (version == QSysInfo::WV_XP) {
    // 日本語ロケールの場合、SJIS に変換する
    QTextCodec* codec = QTextCodec::codecForName("Shift-JIS");
    return codec->fromUnicode(text);

  } else {
    return text;
  }
#else
  return text;
#endif
}
