/*!
  \file
  \brief 部品生成ツールのウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QCloseEvent>
#include <QMessageBox>
#include "PartsGeneratorWindow.h"


struct PartsGeneratorWindow::pImpl {

  QAction* new_act_;
  QAction* open_act_;
  QAction* save_act_;

  void initializeForm(PartsGeneratorWindow* parent) {

    // アイコンの適用
    parent->setWindowIcon(QIcon(":icons/parts_generator_icon"));

    parent->dummy_label_->setText("");
    // !!!

    // メニューイベント
    connect(parent->action_quit_, SIGNAL(triggered()), parent, SLOT(close()));
  }
};


PartsGeneratorWindow::PartsGeneratorWindow(void)
  : QMainWindow(), pimpl(new pImpl) {
  setupUi(this);

  // ツールバーの初期化
  pimpl->new_act_ = new QAction(QIcon(":icons/new_icon"), tr("New"), this);
  pimpl->new_act_->setStatusTip(tr("Create a new config file."));
  connect(pimpl->new_act_, SIGNAL(triggered()), this, SLOT(newFile()));

  pimpl->open_act_ = new QAction(QIcon(":icons/open_icon"), tr("Open"), this);
  pimpl->open_act_->setStatusTip(tr("Open an exist config file."));
  connect(pimpl->open_act_, SIGNAL(triggered()), this, SLOT(openFile()));

  pimpl->save_act_ = new QAction(QIcon(":icons/save_icon"), tr("Save"), this);
  pimpl->save_act_->setStatusTip(tr("Save the config file to disk."));
  connect(pimpl->save_act_, SIGNAL(triggered()), this, SLOT(saveFile()));

  toolbar_->addAction(pimpl->new_act_);
  toolbar_->addAction(pimpl->open_act_);
  toolbar_->addAction(pimpl->save_act_);

  // フォームの初期化
  pimpl->initializeForm(this);

  // メニューの初期化
  connect(action_about_, SIGNAL(triggered()), this, SLOT(aboutApplication()));

  // !!!
}


PartsGeneratorWindow::~PartsGeneratorWindow(void) {
}


// 終了
void PartsGeneratorWindow::closeEvent(QCloseEvent* event) {

  event->accept();
}


// このアプリケーションについて
void PartsGeneratorWindow::aboutApplication(void) {

  QMessageBox::about(this, tr("About parts_generator"),
                     tr("<h2>Parts generator</h2>"
                        "<p>Theme making sub tool for Qtmclock.</p>"
                        "<p>Report bugs to "
                        "&lt;satofumi@users.sourceforge.jp&gt;</p>"));
}
