#ifndef THEME_CLOCK_DRAW_H
#define THEME_CLOCK_DRAW_H

/*!
  \file
  \brief テーマ時計の描画

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QWidget>


/*!
  \brief テーマ時計の描画クラス
*/
class ThemeClockDraw : public QWidget {
  Q_OBJECT;

  ThemeClockDraw(const ThemeClockDraw& rhs);
  ThemeClockDraw& operator = (const ThemeClockDraw& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  /*!
    \brief 描画イベント処理

    \param event [i/o] イベント
  */
  void paintEvent(QPaintEvent* event);

  /*!
    \brief Qt のクローズイベント

    \param event [i/o] イベント
  */
  void closeEvent(QCloseEvent* event);

public:
  /*!
    \brief コンストラクタ

    \param parent [i] 親ウィジット
  */
  ThemeClockDraw(QWidget* parent = 0);

  ~ThemeClockDraw(void);


  /*!
    \brief テーマファイルの読み出し

    \param theme_file [i] テーマファイル
    \param key [i] RRDA キー

    \retval true 成功
    \retval エラー
  */
  bool loadThemeFile(const QString& theme_file, const char* key = "LMTC");


  /*!
    \brief テーマのリソースからの読み出し
  */
  bool loadThemeResource(const QMap<std::string, QPixmap*>& pixmaps,
                         const QMap<std::string, QRect>& offset,
                         const QVector<QPoint>& digital_positions,
                         const QVector<QPoint>& calendar_positions,
                         const QMap<std::string, std::string>& option);


  /*!
    \brief テーマファイル名を返す

    \return テーマファイル名

    \attention テーマがロードされていない場合は、"" を返す
  */
  const QString getThemeFile(void);


  /*!
    \brief テーマ時計の再描画を行う

    \param sec_offset [i] 描画時間のオフセット [秒]
  */
  void redraw(int sec_offset = 0, QWidget* parent = NULL);


  /*!
    \brief 透過領域の取得

    \return 透過領域
  */
  QRegion* getRegion(void);


  /*!
    \brief 描画の拡大率を設定

    \param percent [i] 描画の拡大率
  */
  void updateScalingPercent(size_t percent);

signals:
  /*!
    \brief 終了シグナルを投げる
  */
  void previewClose(void);
};

#endif /*! THEME_CLOCK_DRAW_H */
