/*!
  \file
  \brief データファイルのリリース処理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <string>
#include "ReleaseDataFile.h"
#include "ArchiveConfig.h"
#include "RrdaDecoder.h"


bool releaseDataFile(const ArchiveConfig& archive_config) {

  RrdaDecoder decoder(archive_config.getReleaseName(),
                      archive_config.getRrdaKey());

  const char* tags[] = {
    "config", "base", "digital", "hari_h", "hari_m", "hari_s",
    "days", "separator", "week", "near",
  };

  size_t n = sizeof(tags) / sizeof(tags[0]);

  // 通常データ
  for (size_t i = 0; i < n; ++i) {
    const std::string value = archive_config.getNormalData(tags[i]);
    if (! value.empty()) {
      decoder.setNormalData(tags[i], value);
    }
  }

  // 制限データ
  for (size_t i = 0; i < n; ++i) {
    const std::string value = archive_config.getRestrictData(tags[i]);
    if (! value.empty()) {
      decoder.setRestrictData(tags[i], value);
    }
  }

  return decoder.release();
}

